/** HEAGLER TECNOLOGIA
 * @ Autor: Heagler Tecnologia
 * @ Developer: Deivid Kaiser
 * @ Date : 29/05/2020
 * @ email: contato@heagler.com | deividkaiser@heagler.com
 * ******** www.heagler.com
 **/

$(function() {
    $('.coin_bra').mask('#.##0,00', { reverse: true });
    $('.money2').mask('#,##0.00', { reverse: true });
    $('.zip_code').mask('00000-000');
    $('.cpf').mask('000.000.000-00', { reverse: true });
    $('.pis').mask('000.00000.00-0', { reverse: true });
    $('.cnpj').mask('00.000.000/0000-00', { reverse: true });
    /*  $('.phone_with_ddd').mask('(00)0 0000-0000');
     $('.phone').mask('(00)0000-00000'); */
    $('.uf').mask('AA');
    $('.selectonfocus').mask("00000000", { selectOnFocus: true });

    var maskPhone = function(val) {
            return val.replace(/\D/g, '').length === 11 ? '(00) 00000-0000' : '(00) 0000-00009';
        },
        spOptions = {
            onKeyPress: function(val, e, field, options) {
                field.mask(maskPhone.apply({}, arguments), options);
            }
        };

    $('.phone').mask(maskPhone, spOptions);
})

$(document).on('keydown', '[data-mask-for-cpf-cnpj]', function(e) {

    var digit = e.key.replace(/\D/g, '');

    var value = $(this).val().replace(/\D/g, '');

    var size = value.concat(digit).length;

    $(this).mask((size <= 11) ? '000.000.000-00' : '00.000.000/0000-00');
});